<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\NotificationConfig;

class NotificationConfigTableSeeder extends Seeder
{
    public function run()
    {
        $this->defaultNotificationConfig();
    }

    function defaultNotificationConfig()
    {
        $data = [
            [
                "title"                 => "Add New Blog",
                "code"                  =>"BLOG-ANB",
                "table_model"           =>"Blog",
                "notification_types"    => "1",
                "placeholders"          => "<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"            =>"1",
            ],
            [
                "title"                 => "Update Blog",
                "code"                  => "BLOG-UB",
                "table_model"           => "Blog",
                "notification_types"    => "1",
                "placeholders"          => "<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                => "1"
            ],
            [
                "title"                 => "Delete Blog",
                "code"                  => "BLOG-DB",
                "table_model"           => "Blog",
                "notification_types"    => "1",
                "placeholders"          => "<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                => "1",
            ],
            [
                "title"                 => "Trash Blog",
                "code"                  => "BLOG-TB",
                "table_model"           => "Blog",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                    "status"                =>"1",
            ],
            [
                "title"                 => "Add New Blog Category",
                "code"                  => "BLOG-ANBC",
                "table_model"           => "BlogCategory",
                "notification_types"    => "1",
                "placeholders"          => "<b>BlogCategory Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGCATEGORYTITLE#: Blog category title can display with this placeholder.<br />#BLOGCATEGORYCONTENT#: Blog category content can display with this placeholder.",
                "status"                => "1",
            ],
            [
                "title"                 => "Update Blog Category",
                "code"                  => "BLOG-UBCAT",
                "table_model"           => "BlogCategory",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>BlogCategory Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGCATEGORYTITLE#: Blog category title can display with this placeholder.<br />#BLOGCATEGORYCONTENT#: Blog category content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Delete Blog Category",
                "code"                  => "BLOG-DBCAT",
                "table_model"           => "BlogCategory",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>BlogCategory Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGCATEGORYTITLE#: Blog category title can display with this placeholder.<br />#BLOGCATEGORYCONTENT#: Blog category content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Add New Blog Tag",
                "code"                  => "BLOG-ANBT",
                "table_model"           => "BlogTag",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>BlogTag Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTAGTITLE#: Blog tag title can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Update Blog Tag",
                "code"                  => "BLOG-UBT",
                "table_model"           => "BlogTag",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>BlogTag Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTAGTITLE#: Blog tag title can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Delete Blog Tag",
                "code"                  => "BLOG-DBT",
                "table_model"           => "BlogTag",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>BlogTag Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTAGTITLE#: Blog tag title can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "New Blog Comment",
                "code"                  => "BLOG-NBC",
                "table_model"           => "Comment",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Comment Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGCOMMENT#: Blog comment can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Update Blog Comment",
                "code"                  => "BLOG-UBC",
                "table_model"           => "Comment",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Comment Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGCOMMENT#: Blog comment can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Trash Blog Comment",
                "code"                  => "BLOG-TBC",
                "table_model"           => "Comment",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Comment Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGCOMMENT#: Blog comment can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Delete Blog Comment",
                "code"                  => "BLOG-BCD",
                "table_model"           => "Comment",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Comment Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGCOMMENT#: Blog comment can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Add New Page",
                "code"                  => "PAGE-ANP",
                "table_model"           => "Page",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Page Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#PAGETITLE#: Page title can display with this placeholder.<br />#PAGECONTENT#: Page content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Update Page",
                "code"                  => "PAGE-UP",
                "table_model"           => "Page",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Page Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#PAGETITLE#: Page title can display with this placeholder.<br />#PAGECONTENT#: Page content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Trash Page",
                "code"                  => "PAGE-TP",
                "table_model"           => "Page",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Page Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#PAGETITLE#: Page title can display with this placeholder.<br />#PAGECONTENT#: Page content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Delete Page",
                "code"                  => "PAGE-DP",
                "table_model"           => "Page",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Page Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#PAGETITLE#: Page title can display with this placeholder.<br />#PAGECONTENT#: Page content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Create New Post Type",
                "code"                  => "CPT-CNPT",
                "table_model"           => "Blog",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Update Post Type",
                "code"                  => "CPT-UPT",
                "table_model"           => "Blog",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Trash Post Type",
                "code"                  => "CPT-TPT",
                "table_model"           => "Blog",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Delete Post Type",
                "code"                  => "CPT-DPT",
                "table_model"           => "Blog",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Create New Taxonomy",
                "code"                  => "CPT-CNT",
                "table_model"           => "Blog",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Update Taxonomy",
                "code"                  => "CPT-UT",
                "table_model"           => "Blog",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Trash Taxonomy",
                "code"                  => "CPT-TT",
                "table_model"           => "Blog",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Delete Taxonomy",
                "code"                  => "CPT-DT",
                "table_model"           => "Blog",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Blog Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#BLOGTITLE#: Blog title can display with this placeholder.<br />#BLOGCONTENT#: Blog content can display with this placeholder.<br />#TAXONOMYTITLE#: Taxonomy title can display with this placeholder.<br />#TAXONOMYCONTENT#: Taxonomy content can display with this placeholder.<br />#POSTTYPETITLE#: Post type title can display with this placeholder.<br />#POSTTYPECONTENT#: Post type content can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Add New User",
                "code"                  => "ADMIN-ANU",
                "table_model"           => "User",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>User Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#FULLNAME#: Firstname can display with this placeholder.<br />#EMAIL#: Firstname can display with this placeholder.<br />#FIRSTNAME#: Firstname can display with this placeholder.<br />#LASTNAME#: Lastname can display with this placeholder.<br />#PASSWORD#: password can display with this placeholder.<br />#ROLE#: User role can display with this placeholder.<br />#PROFILE#: User profile can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Update User",
                "code"                  => "ADMIN-UP",
                "table_model"           => "User",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>User Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#FULLNAME#: Firstname can display with this placeholder.<br />#EMAIL#: Firstname can display with this placeholder.<br />#FIRSTNAME#: Firstname can display with this placeholder.<br />#LASTNAME#: Lastname can display with this placeholder.<br />#PASSWORD#: password can display with this placeholder.<br />#ROLE#: User role can display with this placeholder.<br />#PROFILE#: User profile can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Delete User",
                "code"                  => "ADMIN-DU",
                "table_model"           => "User",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>User Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#FULLNAME#: Firstname can display with this placeholder.<br />#EMAIL#: Firstname can display with this placeholder.<br />#FIRSTNAME#: Firstname can display with this placeholder.<br />#LASTNAME#: Lastname can display with this placeholder.<br />#PASSWORD#: password can display with this placeholder.<br />#ROLE#: User role can display with this placeholder.<br />#PROFILE#: User profile can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Update User Password",
                "code"                  => "ADMIN-UUPASS",
                "table_model"           => "User",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>User Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#FULLNAME#: Firstname can display with this placeholder.<br />#EMAIL#: Firstname can display with this placeholder.<br />#FIRSTNAME#: Firstname can display with this placeholder.<br />#LASTNAME#: Lastname can display with this placeholder.<br />#PASSWORD#: password can display with this placeholder.<br />#ROLE#: User role can display with this placeholder.<br />#PROFILE#: User profile can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Assign User Role",
                "code"                  => "ADMIN-AUR",
                "table_model"           => "User",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>User Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#FULLNAME#: Firstname can display with this placeholder.<br />#EMAIL#: Firstname can display with this placeholder.<br />#FIRSTNAME#: Firstname can display with this placeholder.<br />#LASTNAME#: Lastname can display with this placeholder.<br />#PASSWORD#: password can display with this placeholder.<br />#ROLE#: User role can display with this placeholder.<br />#PROFILE#: User profile can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Add New Role",
                "code"                  => "ADMIN-ANR",
                "table_model"           => "Role",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Role Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#NAME#: Firstname can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Update Role",
                "code"                  => "ADMIN-UR",
                "table_model"           => "Role",
                "notification_types"    =>"1",
                "placeholders"          =>"<b>Role Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#NAME#: Firstname can display with this placeholder.",
                "status"                =>"1",
            ],
            [
                "title"                 => "Delete Role",
                "code"                  => "ADMIN-DR",
                "table_model"           => "Role",
                "notification_types"    => "1",
                "placeholders"          => "<b>Role Configuration </b><br />#USERNAME#: Username can display with this placeholder.<br />#NAME#: Firstname can display with this placeholder.",
                "status"                => "1",
            ],
            [
                "title"                 => "Contact Form Inquery",
                "code"                  => "Admin-CFI",
                "table_model"           => "Contact",
                "notification_types"    => "1",
                "placeholders"          => "<b>Contact Configuration </b><br />#FIRSTNAME#: Contact user First name can display with this placeholder.<br />#LASTNAME#: Contact user Last name can display with this placeholder.<br />#PHONENUMBER#: Contact user Phone Number can display with this placeholder.<br />#EMAIL#: Contact user email can display with this placeholder.<br />#MESSAGE#: Contact user message can display with this placeholder.",
                "status"                =>"1",
            ],
        ];
        NotificationConfig::insert($data);
    }
}
